/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import cz.insophy.inplan.planning.PlanningAlgorithm;
import cz.insophy.inplan.planning.PlanningAlgorithmController;
import cz.insophy.inplan.planning.jmx.PlanningController;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.validation.PlanNotValidException;
import cz.insophy.inplan.validation.ValidationResult;
import java.lang.management.ManagementFactory;
import javax.annotation.Nonnull;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PlanningRunner<T extends PlanningAlgorithm> {
    private static final Logger log = LoggerFactory.getLogger(PlanningRunner.class);
    private boolean createdNewSuperplan = false;
    protected Superplan superplan;
    private T algorithm;
    private boolean registerJmx;

    protected PlanningRunner() {
    }

    public void setSuperplan(Superplan superplan) throws PlanNotValidException {
        Preconditions.checkState(this.algorithm == null, "cannot set superplan after getPlanningAlgorithm");
        ValidationResult validationResult = this.validate(superplan);
        if (!validationResult.isValid()) {
            throw new PlanNotValidException("Submitted plan is not valid for further planning.");
        }
        this.superplan = superplan;
    }

    protected abstract ValidationResult validate(Superplan var1);

    public Superplan getSuperplan() {
        return this.superplan;
    }

    public boolean hasCreatedNewSuperplan() {
        return this.createdNewSuperplan;
    }

    protected void setNewSuperplan(Superplan superplan) {
        this.superplan = superplan;
        this.createdNewSuperplan = true;
    }

    public boolean isRegisterJmx() {
        return this.registerJmx;
    }

    public void setRegisterJmx(boolean registerJmx) {
        this.registerJmx = registerJmx;
    }

    @Nonnull
    protected abstract T createPlanningAlgorithm();

    @Nonnull
    @VisibleForTesting
    public T getPlanningAlgorithm() {
        Preconditions.checkState(this.superplan != null, "Superplan must be set in %s.", (Object)this.getClass().getSimpleName());
        if (this.algorithm == null) {
            this.algorithm = this.createPlanningAlgorithm();
            Preconditions.checkState(this.algorithm != null, "Planning algorithm cannot be null.");
        }
        return this.algorithm;
    }

    public PlanningAlgorithmController getPlanningAlgorithmController() {
        return this.getPlanningAlgorithm().getPlanningAlgorithmSupport();
    }

    public final void run() {
        ObjectName mcName = null;
        if (this.registerJmx) {
            try {
                mcName = new ObjectName("cz.insophy.inplan.planning.jmx:type=PlanningController");
                ManagementFactory.getPlatformMBeanServer().registerMBean(new PlanningController(this.getPlanningAlgorithmController()), mcName);
            }
            catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
                log.warn("Cannot register JMX controller. {}", (Object)e.getMessage());
                mcName = null;
            }
        }
        this.doRun();
        if (mcName != null) {
            try {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(mcName);
            }
            catch (InstanceNotFoundException | MBeanRegistrationException e) {
                log.warn("Cannot unregister JMX controller. {}", (Object)e.getMessage());
            }
        }
    }

    protected abstract void doRun();
}

